''' The post processing script for producing dispersion curves
    It is assumed that numpy and matplotlib (together forming pylab)
    are installed
'''

import sys
from pylab import *
arg=sys.argv

#Check for the correct number of arguments
if len(arg)!=5:
  print 'run the script with python post_process.py "path to time data file" "path to transformed data file" "path for saving spin waves plot" "path for saving dispersion plot"';exit()

#Load time and space series data
data=loadtxt(arg[1])

#Extracting time sample points
tdata=data[:,0];tdata=unique(tdata)
#Extracting space sample points
xdata=data[:,1];xdata=unique(xdata)
#Extracting magnetization sample points
mdata=data[:,4]
mdata.shape=(tdata.shape[0],xdata.shape[0])

#Modify colorbar to get good plot
cbmax = mdata.max()/5.
cbmin = mdata.min()/5.

#To plot the spin wave curve
figure(1)
pcolormesh(xdata,tdata*1e9,mdata, vmax = cbmax, vmin = cbmin)
xlabel('length (nm)', fontsize=18)
ylabel('time (ns)', fontsize=18)
xlim(0, xdata[xdata.shape[0]-1])
ylim(0,tdata[tdata.shape[0]-1]*1e9)
cb = colorbar()
savefig(arg[3])

#Load the frequency and wave number series data
dataf=loadtxt(arg[2])
fdata=dataf[:,0];fdata=unique(fdata)
kdata=dataf[:,1];kdata=unique(kdata)

#Apply hanning window in time and space
wmdata = mdata.copy()
hannx = hanning(xdata.shape[0])
hannt = hanning(tdata.shape[0])

for i in range(tdata.shape[0]):
    wmdata[i, :] = wmdata[i, :] * hannx

for i in range(xdata.shape[0]):
    wmdata[:, i] = wmdata[:, i] * hannt

fwmdata = abs(fftshift(fft2(wmdata)))

#Modify colorbar to get good plots
cbmax = 10*log10((fwmdata)**2).max()/2.
cbmin = 10*log10((fwmdata)**2).min()/2.

#To plot the time windowed log dispersion plot
figure(2)
ax = pcolormesh(kdata,fdata/(2*pi*1e9),10*log10((fwmdata**2)), vmax = cbmax, vmin = cbmin)
xlabel(r'$k_{x}\,\mathrm{(rad/nm)}$', fontsize=18)
ylabel('f (GHz)', fontsize=18)
ylim(0,400)
cb = colorbar()
savefig(arg[4])
